/* =============================================================================
 *
 * main.c
 *
 * This file contains the main() function plus the call-backs for
 * vApplicationStackOverflowHook() and vApplicationMallocFailedHook().
 *
 * v1.0	YFS	Initial release. 
 *
 * =============================================================================
*/

/*
* Copyright (2014), Cypress Semiconductor Corporation. All Rights Reserved.
*
* This software is owned by Cypress Semiconductor Corporation (Cypress)
* and is protected by and subject to worldwide patent protection (United
* States and foreign), United States copyright laws and international treaty
* provisions. Cypress hereby grants to licensee a personal, non-exclusive,
* non-transferable license to copy, use, modify, create derivative works of,
* and compile the Cypress Source Code and derivative works for the sole
* purpose of creating custom software in support of licensee product to be
* used only in conjunction with a Cypress integrated circuit as specified in
* the applicable agreement. Any reproduction, modification, translation,
* compilation, or representation of this software except as specified above 
* is prohibited without the express written permission of Cypress.
*
* Disclaimer: CYPRESS MAKES NO WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, WITH 
* REGARD TO THIS MATERIAL, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED 
* WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE.
* Cypress reserves the right to make changes without further notice to the 
* materials described herein. Cypress does not assume any liability arising out 
* of the application or use of any product or circuit described herein. Cypress 
* does not authorize its products for use as critical components in life-support 
* systems where a malfunction or failure may reasonably be expected to result in 
* significant injury to the user. The inclusion of Cypress' product in a life-
* support systems application implies that the manufacturer assumes all risk of 
* such use and in doing so indemnifies Cypress against all charges. 
*
* Use of this Software may be limited by and subject to the applicable Cypress
* software license agreement. 
*/

/* Include FreeRTOS APIs and defines */
#include <FreeRTOS.h>
#include <task.h>
#include <queue.h>
#include <event_groups.h>

/* Include PSoC system and component APIs and defines */
#include <project.h>

/* Include application function declarations and defines */
#include <utils.h>
#include <Task_Defs.h>

/* Declaration of NVIC base vector for FreeRTOS exception handling */
#define CORTEX_INTERRUPT_BASE          (16)

/* Declarations of the exception handlers for FreeRTOS */
extern void xPortPendSVHandler(void);
extern void xPortSysTickHandler(void);
extern void vPortSVCHandler(void);

/*
 * Function:	main
 *
 * Initialize the system, create the first task (Main_Task) and start the OS.
 *
 * Globals:		Updates the vector table and allocates task memory from heap.
 *
 * Parameters:	None
 *
 * Return:		None (vTaskStartScheduler API never returns)
 */
int main( void )
{
    BaseType_t taskCreated;             /* Return value from xTaskCreate */
	
	/* Initialize the OS vectors - make it ready to create the task, below */
    
    /* Handler for Cortex Supervisor Call (SVC, formerly SWI) - address 11 */
    CyIntSetSysVector( CORTEX_INTERRUPT_BASE + SVCall_IRQn,
        (cyisraddress)vPortSVCHandler );
    
    /* Handler for Cortex PendSV Call - address 14 */
	CyIntSetSysVector( CORTEX_INTERRUPT_BASE + PendSV_IRQn,
        (cyisraddress)xPortPendSVHandler );    
    
    /* Handler for Cortex SYSTICK - address 15 */
	CyIntSetSysVector( CORTEX_INTERRUPT_BASE + SysTick_IRQn,
        (cyisraddress)xPortSysTickHandler );
     	
	/* Create the Main Task - it will not run until vTaskStartScheduler */
    taskCreated = xTaskCreate(
        Main_Task,                  /* Task function */
        MAIN_TASK,                  /* Task name (string) */
        MAIN_TASK_STACK_SIZE,       /* Task stack, allocated from heap */
        NO_TASK_ARG,                /* Argument to task function */
        MAIN_TASK_PRIORITY,         /* Priority */
        TASK_HANDLE_UNUSED );       /* Task handle */
    
    /* If the task(s) are created successfully, start the OS */
    if( taskCreated )
    {
        vTaskStartScheduler();
    }
    else
    {
        report_error( "Main task" );
    }
    
    return 0;       /* Never happens - neither if block ever returns */
	
} /* main() */

/*
 * Function:	vApplicationStackOverflowHook
 *
 * Called if a task exceeds its alloted stack.
 *
 * Requires configCHECK_FOR_STACK_OVERFLOW to be set in FreeRTOSConfig.h.
 *
 * Globals:		None
 *
 * Parameters:	Task handle and name
 *
 * Return:		Never returns - this is a fatal error condition
 */
void vApplicationStackOverflowHook( xTaskHandle pxTask, signed char *pcTaskName )
{
	/* The stack space has been execeeded for a task */
	taskDISABLE_INTERRUPTS();
	while( 1 )
    {
        /* Do nothing - this is a placeholder for a breakpoint */
    }
}

/*
 * Function:	vApplicationMallocFailedHook
 *
 * Called if a malloc from the FreeRTOS heap fails. This may require more
 * heap (configTOTAL_HEAP_SIZE in FreeRTOSVConfig.h) or a different heap
 * algorithm (heap_?.c in Source\portable\MemMang).
 *
 * Requires configUSE_MALLOC_FAILED_HOOK to be set in FreeRTOSConfig.h.
 *
 * Globals:		None
 *
 * Parameters:	Task handle and name
 *
 * Return:		Never returns - this is a fatal error condition
 */
void vApplicationMallocFailedHook( void )
{
	/* The heap space has been execeeded. */
	taskDISABLE_INTERRUPTS();
	while( 1 )
    {
        /* Do nothing - this is a placeholder for a breakpoint */
    }
}
